/*****************************************************************************
*  LPC54x SCT0 Match toggle for LPCXpresso board
*
*  1. Use SCT0 timer to generate a 100 msec clock output @ SCT_OUT5
*  2. SCT0_OUT5 is linked to P1_2 (toggles every 100 msec)
*****************************************************************************/

#include "board.h"

/*****************************************************************************
 * Private types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Public types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Private functions
 ****************************************************************************/
void SCT_Init(void);
/*****************************************************************************
 * Public functions
 ****************************************************************************/
void SCT_Init(void)
{

	Chip_SCT_Init(LPC_SCT);                								               // enable the SCT0 clock

	Chip_SCT_Config(LPC_SCT, 	SCT_CONFIG_16BIT_COUNTER 	|
                              SCT_CONFIG_AUTOLIMIT_L 		);				       // two 16 bit timers, auto limit

	Chip_SCT_SetControl(LPC_SCT, SCT_CTRL_PRE_L(119));					           // PRE_L[12:5] = 120-1 (SCT clock = 12MHz/120 = 100 KHz)

	Chip_SCT_SetMatchCount(LPC_SCT, SCT_MATCH_0, (100000/10)-1);						        // match 0 @ 10 Hz = 100 msec
	Chip_SCT_SetMatchReload(LPC_SCT, SCT_MATCH_0, (100000/10)-1);

	Chip_SCT_EventState(LPC_SCT, SCT_EVENT_0 , ENABLE_ALL_STATES);			  // event 0 happens in all state
	Chip_SCT_EventControl(LPC_SCT, SCT_EVENT_0 , SCT_COMBMODE_MATCH);		// match 0 condition only

	Chip_SCT_SetOutput(LPC_SCT, SCT_OUTPUT_5 , SCT_EVT_0);					      // event 0 will set   SCT0_OUT5
	Chip_SCT_ClearOutput(LPC_SCT, SCT_OUTPUT_5, SCT_EVT_0);				      // event 0 will clear SCT0_OUT5

	Chip_SCT_SetConflictResolution(LPC_SCT, SCT_OUTPUT_5 ,SCT_RES_TOGGLE_OUTPUT);		// output5 toggles on conflict

	Chip_SCT_ClearControl(LPC_SCT,SCT_CTRL_HALT_L);               			  // start timer
}


int main(void)
{
	SystemCoreClockUpdate();
  Board_Init();
  
  LPC_SYSCON->AHBCLKDIV = 8;

  	Chip_Clock_EnablePeriphClock((CHIP_SYSCON_CLOCK_T)  ( SYSCON_CLOCK_IOCON	| SYSCON_CLOCK_GPIO1));									//enable ICON clock and GPIO1 clock

  	Chip_IOCON_PinMuxSet(LPC_IOCON, 1, 2, IOCON_FUNC3 | IOCON_MODE_INACT | IOCON_DIGITAL_EN | IOCON_INPFILT_OFF);			//SCT0_OUT5 = P1.2  (green   LED)


    SCT_Init();                                           			       	// Initialize SCT0

    while (1)                                              					    // loop forever
    {
    	__WFI();
    }
}
